#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

APPNAME=ncurses
VER=5.9
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr           \
            --mandir=/usr/share/man \
            --with-shared           \
            --without-debug         \
            --enable-pc-files       \
            --enable-widec          \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "mv -v /usr/lib/libncursesw.so.5* /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1

paco -p+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libncursesw.so) /usr/lib/libncursesw.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

for lib in ncurses form panel menu ; do \
    rm -vf                    /usr/lib/lib${lib}.so ; \
    echo "INPUT(-l${lib}w)" > /usr/lib/lib${lib}.so ; \
    paco -p+ $TARGET "\
    ln -sfv lib${lib}w.a      /usr/lib/lib${lib}.a" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 ; \
    paco -p+ $TARGET "\
    ln -sfv ${lib}w.pc        /usr/lib/pkgconfig/${lib}.pc" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 ; \
done || exit 1
paco -p+ $TARGET "\
ln -sfv libncurses++w.a /usr/lib/libncurses++.a" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
rm -vf /usr/lib/libcursesw.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET 'echo "INPUT(-lncursesw)" >/usr/lib/libcursesw.so'
paco -p+ $TARGET "ln -sfv libncurses.so /usr/lib/libcurses.so"
paco -p+ $TARGET "ln -sfv libncursesw.a /usr/lib/libcursesw.a"
paco -p+ $TARGET "ln -sfv libncurses.a /usr/lib/libcurses.a"

mkdir -v       /usr/share/doc/ncurses-$VER
paco -p+ $TARGET "cp -v -R doc/* /usr/share/doc/ncurses-$VER" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Done.

