BOOTSCRIPTVER=20130216
SVNVER=1.2.0
LINUX_VER=3.4.17

CLFS=/mnt/clfs
SRC=$CLFS/sources/CLFS
DLD=$CLFS/download/CLFS/x86_64
WRK=$CLFS/work/LFScripts/CLFS/x86_64
LOG=$WRK/log
TME=$WRK/time

mkdir -pv $LOG $TME

function TimeStart() {
  START=`date +'%Y/%m/%d %H:%M:%S.%N'`
  return 0
}

function TimeEnd() {
  END=`date +'%Y/%m/%d %H:%M:%S.%N'`
  echo $CHAP,$TARGET,$START,$END \
        >> $TME/clfstime.txt
}

function RemoveSrcDir() {
  echo Removing source directory...
  rm -fr $TARGETDIR
}

function Extract() {
  local FILE=$TARGETBALL

  if test "$1" != ""; then
    FILE=$1
  fi

  echo Extracting sources...
  if test ! -f $FILE; then
    echo \ \ Tarball not found: $FILE && exit 1
  else
    tar xf $FILE
  fi
}

function PacoingDone() {
  local pkg=$TARGET
  if test "$1" != ""; then
    pkg=$1
  fi
  echo --------------------
  echo -n Pacoing:\   && paco $pkg || echo none
  echo Done.
}
