#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=8.5.12
TARGET=tcl-$VER
TARGETBALL=tcl$VER-src.tar.gz
TARGETDIR=tcl$VER

echo $CHAP: $TARGET

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo \ \ Configuring...
cd unix
CC="gcc ${BUILD64}" ./configure --prefix=/tools --libdir=/tools/lib64 \
        1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
        1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
        1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
make install-private-headers \
        1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
ln -sv tclsh8.5 /tools/bin/tclsh \
        1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
        >> $TME/clfstime.txt

echo \ \ Removing Directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

