#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=7.3
TARGET=vim-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=vim73

echo $CHAP: $TARGET

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/vim-$VER-branch_update-6.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

cp -v src/auto/configure{,.orig}
sed "/using uint32_t/s/as_fn_error/#&/" src/auto/configure.orig > src/auto/configure

cat > src/auto/config.cache << "EOF"
vim_cv_getcwd_broken=no
vim_cv_memmove_handles_overlap=yes
vim_cv_stat_ignores_slash=no
vim_cv_terminfo=yes
vim_cv_tgent=zero
vim_cv_toupper_broken=no
vim_cv_tty_group=world
ac_cv_sizeof_int=4
ac_cv_sizeof_long=4
ac_cv_sizeof_time_t=4
ac_cv_sizeof_off_t=4
EOF

echo '#define SYS_VIMRC_FILE "/tools/etc/vimrc"' >> src/feature.h

echo \ \ Configuring...
CC="${CC} ${BUILD64}" CXX="${CXX} ${BUILD64}" \
  ./configure --build=${CLFS_HOST} --host=${CLFS_TARGET} \
  --prefix=/tools --enable-multibyte --enable-gui=no \
  --disable-gtktest --disable-xim --with-features=normal \
  --disable-gpm --without-x --disable-netbeans \
  --with-tlib=ncurses \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
ln -sv vim /tools/bin/vi \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

cat > /tools/etc/vimrc << "EOF"
" Begin /etc/vimrc

set nocompatible
set backspace=2
set ruler
syntax on

" End /etc/vimrc
EOF

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/clfstime.txt

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

