#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=8.20
TARGET=coreutils-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

touch man/uname.1 man/hostname.1

cat > config.cache << EOF
fu_cv_sys_stat_statfs2_bsize=yes
gl_cv_func_working_mkstemp=yes
EOF

echo \ \ Configuring...
CC="${CC} ${BUILD64}" ./configure --prefix=/tools \
    --build=${CLFS_HOST} --host=${CLFS_TARGET} \
    --enable-install-program=hostname --cache-file=config.cache \
        1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

cp -v Makefile{,.orig}
sed '/src_make_prime_list/d' Makefile.orig > Makefile
depbase=`echo src/make-prime-list.o | sed 's|[^/]*$|.deps/&|;s|\.o$||'`;\
    gcc -std=gnu99  -I. -I./lib  -Ilib -I./lib -Isrc -I./src  \
    -fdiagnostics-show-option -funit-at-a-time -g -O2 -MT \
    src/make-prime-list.o -MD -MP -MF $depbase.Tpo -c -o src/make-prime-list.o \
    src/make-prime-list.c &&
mv -f $depbase.Tpo $depbase.Po
gcc -std=gnu99 -fdiagnostics-show-option -funit-at-a-time -g -O2 \
    -Wl,--as-needed  -o src/make-prime-list src/make-prime-list.o

cp -v Makefile{,.bak}
sed -e '/hostname.1/d' Makefile.bak > Makefile

echo \ \ Making...
make \
        1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
        1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
        >> $TME/clfstime.txt

echo \ \ Removing Directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

