#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=4.6.3
TARGET=gcc-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr gcc-build

. $WRK/_extract.sh

cd $TARGETDIR

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo \ \ Patching...
patch -Np1 -i $DLD/gcc-$VER-branch_update-2.patch \
        1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/gcc-$VER-specs-1.patch \
        1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

echo -en '#undef STANDARD_INCLUDE_DIR\n#define STANDARD_INCLUDE_DIR "/tools/include/"\n\n' >> gcc/config/linux.h
echo -en '\n#undef STANDARD_STARTFILE_PREFIX_1\n#define STANDARD_STARTFILE_PREFIX_1 "/tools/lib/"\n' >> gcc/config/linux.h
echo -en '\n#undef STANDARD_STARTFILE_PREFIX_2\n#define STANDARD_STARTFILE_PREFIX_2 ""\n' >> gcc/config/linux.h

cp -v gcc/Makefile.in{,.orig}
sed -e "s@\(^CROSS_SYSTEM_HEADER_DIR =\).*@\1 /tools/include@g" \
    gcc/Makefile.in.orig > gcc/Makefile.in

mkdir -v ../gcc-build
cd ../gcc-build

echo \ \ Configuring...
AR=ar LDFLAGS="-Wl,-rpath,/cross-tools/lib" \
  ../gcc-4.6.3/configure --prefix=/cross-tools \
  --build=${CLFS_HOST} --target=${CLFS_TARGET} --host=${CLFS_HOST} \
  --with-sysroot=${CLFS} --with-local-prefix=/tools --disable-nls \
  --enable-shared --disable-static --enable-languages=c,c++ \
  --enable-__cxa_atexit --with-mpfr=/cross-tools --with-gmp=/cross-tools \
  --enable-c99 --with-ppl=/cross-tools --with-cloog=/cross-tools \
  --enable-long-long --enable-threads=posix --enable-cloog-backend=isl \
        1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make AS_FOR_TARGET="${CLFS_TARGET}-as" \
    LD_FOR_TARGET="${CLFS_TARGET}-ld" \
        1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
        1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
        >> $TME/clfstime.txt

echo \ \ Removing Directory...
cd .. && rm -fr $TARGETDIR
rm -fr gcc-build

echo \ \ Done.

