#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=4.13a
TARGET=texinfo-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=texinfo-4.13

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/texinfo-$VER-new_compressors-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

echo Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/usr \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

pushd /usr/share/info
rm dir
for f in *
do install-info $f dir 2>/dev/null
done
popd

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

