#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=5.16.2
TARGET=perl-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

sed -i -e '/^BUILD_ZLIB/s/True/False/' \
       -e '/^INCLUDE/s,\./zlib-src,/usr/include,' \
       -e '/^LIB/s,\./zlib-src,/usr/lib,' \
       cpan/Compress-Raw-Zlib/config.in

echo "127.0.0.1 localhost $(hostname)" > /etc/hosts

echo Configuring...
./configure.gnu --prefix=/usr \
   -Dvendorprefix=/usr \
   -Dman1dir=/usr/share/man/man1 \
   -Dman3dir=/usr/share/man/man3 \
   -Dpager="/bin/less -isR" \
   -Dcc="gcc ${BUILD32}" \
   -Dusethreads -Duseshrplib \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
    DOCDIR=/usr/share/doc/iproute2 MANDIR=/usr/share/man \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/perl{,-32}" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/perl5.16.2{,-32}" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone
