#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=3.2.8
TARGET=procps-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/procps-$VER-ps_cgroup-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/procps-$VER-fix_HZ_errors-1.patch \
	1>> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

sed -i -r '/^-include/s/\*(.*)/proc\1 ps\1/' Makefile

echo Making...
make CC="gcc ${BUILD32}" m64="" \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make SKIP='/bin/kill /usr/share/man/man1/kill.1' install lib64=lib" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone
