#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=0.27.1-1
TARGET=pkg-config-lite-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/usr \
    --with-pc-path=/usr/share/pkgconfig \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

export PKG_CONFIG_PATH32="/usr/lib/pkgconfig"
export PKG_CONFIG_PATH64="/usr/lib64/pkgconfig"

cat >> /root/.bash_profile << EOF
export PKG_CONFIG_PATH32="${PKG_CONFIG_PATH32}"
export PKG_CONFIG_PATH64="${PKG_CONFIG_PATH64}"
EOF

TimeEnd

cd ..
RemoveSrcDir
PacoingDone
