#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=5.9
TARGET=ncurses-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/ncurses-$VER-branch_update-4.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

echo Configuring...
CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" \
   ./configure --prefix=/usr --libdir=/lib \
   --with-shared --without-debug --enable-widec \
   --with-manpage-format=normal \
   --with-default-terminfo-dir=/usr/share/terminfo \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/bin/ncursesw5-config{,-32}" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /lib/lib{panelw,menuw,formw,ncursesw,ncurses++w}.a /usr/lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
rm -v /lib/lib{ncursesw,menuw,panelw,formw}.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -svf ../../lib/libncursesw.so.5 /usr/lib/libncursesw.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -svf ../../lib/libmenuw.so.5 /usr/lib/libmenuw.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -svf ../../lib/libpanelw.so.5 /usr/lib/libpanelw.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -svf ../../lib/libformw.so.5 /usr/lib/libformw.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

for lib in curses ncurses form panel menu ; do
        echo "INPUT(-l${lib}w)" > /usr/lib/lib${lib}.so
        paco -p+ $TARGET "\
        ln -sfv lib${lib}w.a /usr/lib/lib${lib}.a" \
		1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
done

paco -p+ $TARGET "\
ln -sfv libcurses.so /usr/lib/libcursesw.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv libncurses.so /usr/lib/libcurses.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv libncursesw.a /usr/lib/libcursesw.a" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv libncurses.a /usr/lib/libcurses.a" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv libncurses++w.a /usr/lib/libncurses++.a" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv ncursesw5-config-32 /usr/bin/ncurses5-config-32" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -sfv ../share/terminfo /usr/lib/terminfo" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone
