#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=5.16.2
TARGET=perl-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo \ \ Patching...
patch -Np1 -i $DLD/perl-$VER-libc-1.patch \
        1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's@/usr/include@/tools/include@g' ext/Errno/Errno_pm.PL

echo \ \ Configuring...
./configure.gnu --prefix=/tools  -Dcc="gcc ${BUILD32}" \
        1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
        1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
        1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
ln -sfv /tools/bin/perl /usr/bin \
        1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
        >> $TME/clfstime.txt

echo \ \ Removing Directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

