#/bin/sh

. ./_cblfsset.sh

APPNAME=dmalloc
VER=5.5.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tgz
TARGETDIR=$TARGET

echo $TARGET

checkRequired ""
checkOptions  ""
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT32
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/dmalloc-$VER-Makefile.in-1.patch \
	1> $LOG/$TARGET.$BIT.0_patch.log 2>&1 || exit 1

echo Configuring...
CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" ./configure --prefix=/usr --enable-shlib --enable-threads \
	1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1
make cxx \
	1>> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
make installcxx" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -svf libdmalloc.so.5.5.2 /usr/lib/libdmalloc.so" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
for lib in cxx th thcxx; do
    paco -p+ $TARGET "\
    ln -svf libdmalloc$lib.so.5.5.2 /usr/lib/libdmalloc$lib.so" \
	1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
done

TimeEnd
cd ..

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/dmalloc-$VER-Makefile.in-1.patch \
        1> $LOG/$TARGET.$BIT.0_patch.log 2>&1 || exit 1

echo Configuring...
CC="gcc ${BUILD64} -fPIC" CXX="g++ ${BUILD64} -fPIC" ./configure --prefix=/usr \
    --libdir=/usr/lib64 --enable-shlib --enable-threads \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1
make cxx \
        1>> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
make installcxx" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -svf libdmalloc.so.5.5.2 /usr/lib64/libdmalloc.so" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
for lib in cxx th thcxx; do
    paco -p+ $TARGET "\
    ln -svf libdmalloc$lib.so.5.5.2 /usr/lib64/libdmalloc$lib.so" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
done

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

