#!/bin/sh

. ./_blfsset.sh

APPNAME=x264
VER=20140115-2245
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-snapshot-$VER-stable.tar.bz2
TARGETDIR=$APPNAME-snapshot-$VER-stable

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	yasm
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --enable-shared \
            --disable-cli \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

