#!/bin/sh

. ./_blfsset.sh

APPNAME=valgrind
VER=3.9.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	boost llvm openmp
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#Patching
#patch -Np1 -i $WRK/patch/valgrind-$VER-glibc-2.17.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's|2.18|2.19|'      configure
sed -i 's|/doc/valgrind||' docs/Makefile.in

Configuring
./configure --prefix=/usr \
            --datadir=/usr/share/doc/valgrind-$VER \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

