#!/bin/sh

. ./_blfsset.sh

APPNAME=Trac
VER=1.0.1
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo Check Required...
./_checkRequired.sh python setuptools || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Compiling catalog...
python ./setup.py compile_catalog -f \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
python ./setup.py compile_catalog -f
paco -p $TARGET "python ./setup.py install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release 2>/dev/null || echo unknown`,\
$TARGET,$START,$END >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

