#!/bin/sh

. ./_blfsset.sh

APPNAME=scons
VER=2.3.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}-$VER.tar.gz
TARGETDIR=${APPNAME}-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	python
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
paco -p $TARGET "\
python setup.py install --standard-lib \
                        --prefix=/usr \
                        --install-data=/usr/share \
                        --optimize=1" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

