#!/bin/sh

. ./_blfsset.sh

APPNAME=samba
VER=4.1.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libtirpc
. $WRK/_checkOptions.sh  \
	popt Linux-PAM cups openldap gamin acl xfsprogs \
	krb5 python-2 libxslt tdb ctdb libcap2 libunwind \
	avahi openafs valgrind 
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i -e "/dmapi_lib/s/$/ldflags='-ltirpc',/" source3/wscript_build

Configuring
./configure                            \
    --prefix=/usr                      \
    --sysconfdir=/etc                  \
    --localstatedir=/var               \
    --with-piddir=/run/samba           \
    --with-pammodulesdir=/lib/security \
    --enable-fhs                       \
    --enable-nss-wrapper \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "\
make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/lib/libnss_win{s,bind}.so*   /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -v -sf ../../lib/libnss_winbind.so.2 /usr/lib/libnss_winbind.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
ln -v -sf ../../lib/libnss_wins.so.2    /usr/lib/libnss_wins.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644    examples/smb.conf.default /etc/samba" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
sed -e "s/MYGROUP/WORKGROUP/" \
    -e "s/writable = yes/writable = yes\n   create mask = 0644\n   directory mask = 0755/" /etc/samba/smb.conf.default > /etc/samba/smb.conf
paco -p+ $TARGET "touch /etc/samba/smb.conf"

mkdir -pv /etc/openldap/schema 

paco -p+ $TARGET "\
install -v -m644    examples/LDAP/README              \
                    /etc/openldap/schema/README.LDAP" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
                    
paco -p+ $TARGET "\
install -v -m644    examples/LDAP/samba*              \
                    /etc/openldap/schema" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
                    
paco -p+ $TARGET "\
install -v -m755    examples/LDAP/{get*,ol*} \
                    /etc/openldap/schema" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/samba-$VER

paco -p+ $TARGET "\
install -v -m644    lib/ntdb/doc/design.pdf \
                    /usr/share/doc/samba-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

