#!/bin/sh

. ./_blfsset.sh

APPNAME=mono
VER=git
TARGET=$APPNAME-$VER
TARGETDIR=$TARGET
GITDIR=/mnt/lfs/sources/git/$APPNAME

echo $TARGET

. $WRK/_checkRequired.sh \
	XML-Parser
. $WRK/_checkOptions.sh  \
	libgdiplus
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
rm -fr $TARGET
mkdir -pv $TARGET
cp -R $GITDIR/* $TARGET

TimeStart

cd $TARGETDIR

if [ ${OPTION_libgdiplus} -eq "1" ]; then
  export WITHLIBGDIPLUS="--with-libgdiplus=installed "
else
  export WITHLIBGDIPLUS="--with-libgdiplus=sibling --without-x "
fi

echo Autogen...
./autogen.sh \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1
make get-monolite-latest
make EXTERNAL_MCS="${PWD}/mcs/class/lib/monolite/gmcs.exe"

Configuring
./configure --prefix=/usr \
	$WITHLIBGDIPLUS \
	--with-libgdiplus=installed \
	--with-profile4=yes \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
rm -fr $TARGET
PacoingDone

