#!/bin/sh

. ./_blfsset.sh

APPNAME=llvm
VER=3.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.src.tar.gz
TARGETDIR=$TARGET

unset MAKEFLAGS

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	doxygen graphviz libffi libxml2 zip \
        ocaml sphinx valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

tar -xf $DLD/clang-3.4.src.tar.gz -C tools || exit 1
tar -xf $DLD/compiler-rt-3.4.src.tar.gz -C projects || exit 1
mv tools/clang-3.4 tools/clang
mv projects/compiler-rt-3.4 projects/compiler-rt

sed -e 's:\$(PROJ_prefix)/docs/llvm:$(PROJ_prefix)/share/doc/llvm-3.4:' \
    -i Makefile.config.in

Configuring
CC=gcc  \
CXX=g++ \
./configure --prefix=/usr              \
            --sysconfdir=/etc          \
            --enable-libffi            \
            --enable-optimized         \
            --enable-shared            \
            --disable-assertions       \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for file in /usr/lib/lib{clang,LLVM,LTO}*.a
do
  test -f $file && chmod -v 644 $file
done

install -v -dm755 /usr/lib/clang-analyzer

for prog in scan-build scan-view
do
  cp -rfv tools/clang/tools/$prog /usr/lib/clang-analyzer/
  ln -sfv ../lib/clang-analyzer/$prog/$prog /usr/bin/
done

ln -sfv /usr/bin/clang /usr/lib/clang-analyzer/scan-build/ 
mv -v /usr/lib/clang-analyzer/scan-build/scan-build.1 /usr/share/man/man1/

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

