#!/bin/sh

. ./_blfsset.sh

APPNAME=libcap2
APPNAME2=libcap
VER=2.23
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME2-$VER.tar.xz
TARGETDIR=$APPNAME2-$VER

echo $TARGET

. $WRK/_checkRequired.sh attr
. $WRK/_checkOptions.sh  \
	Linux-PAM
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

sed -i '/install.*STALIBNAME/ s/^/#/' libcap/Makefile

Installing
paco -p $TARGET "\
make RAISE_SETFCAP=no \
     prefix=/usr      \
     SBINDIR=/sbin install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
chmod -v 755 /usr/lib/libcap.so \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
mv -v /usr/lib/libcap.so.* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "\
ln -sfv ../../lib/libcap.so.2 /usr/lib/libcap.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

