#!/bin/sh

. ./_blfsset.sh

APPNAME=libaio
VER=0.3.109
TARGET=${APPNAME}_$VER
TARGETBALL=$DLD/$TARGET.orig.tar.gz
TARGETDIR=$APPNAME-$VER

echo $TARGET

. $WRK/_checkRequired.sh patchutils
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGETDIR "make prefix=/usr install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone $TARGETDIR

