#!/bin/sh

. ./_blfsset.sh

TARGET=blfs-bootscripts-$BOOTSCRIPTDATE
SCRIPT=install-samba
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $SCRIPT

. $WRK/_checkRequired.sh samba
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd -g 99 nogroup &&
useradd -c "Unprivileged Nobody" -d /dev/null -g nogroup \
    -s /bin/false -u 99 nobody

Installing
paco -p $SCRIPT "make $SCRIPT" \
	1> $LOG/$SCRIPT.1_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone $SCRIPT

