#!/bin/sh

. ./_blfsset.sh

APPNAME=gst-plugins-good
VER=0.10.31
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gst-plugins-base
. $WRK/_checkOptions.sh  \
	cairo flac libjpeg-turbo libpng gconf libsoup \
        aalib gtk+-3 jack libavc1394 libdv pulseaudio speex taglib
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i -e '/input:/d' sys/v4l2/gstv4l2bufferpool.c

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --with-gtk=3.0 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

