#!/bin/sh

. ./_blfsset.sh

APPNAME=gpm
VER=1.20.7
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${TARGET}.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Autogen...
./autogen.sh \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install-info --dir-file=/usr/share/info/dir \
             /usr/share/info/gpm.info" \
	1> $LOG/$TARGET.4_install.log 2>&1 || exit 1

rm -f /usr/lib/libgpm.so
paco -p+ $TARGET "\
ln -v -s libgpm.so.2.1.0 /usr/lib/libgpm.so" \
	1>> $LOG/$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 conf/gpm-root.conf /etc" \
	1>> $LOG/$TARGET.4_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/gpm-$VER/support \
	1>> $LOG/$TARGET.4_install.log 2>&1 || exit 1

install -v -m644    doc/support/* \
                    /usr/share/doc/gpm-$VER/support \
	1>> $LOG/$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644    doc/{FAQ,HACK_GPM,README*} \
                    /usr/share/doc/gpm-$VER" \
	1>> $LOG/$TARGET.4_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

