#!/bin/sh

. ./_blfsset.sh

APPNAME=glib
VER=2.40.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	python pcre libffi
. $WRK/_checkOptions.sh  \
	attr dbus gtk-doc elfutils
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

LIBFIIVER=`paco libffi | sed s/libffi\-//`

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
#PCRE_LIBS=-lpcre  PCRE_CFLAGS=" "                                \
#LIBFFI_LIBS=-lffi LIBFFI_CFLAGS=" " \
./configure --prefix=/usr --with-pcre=system \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#paco -p+ $TARGET "\
#ln -v -sfn ../../lib/glib-2.0/include/glibconfig.h /usr/include/glib-2.0/glibconfig.h" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#paco -p+ $TARGET "\
#cat > /etc/profile.d/glib2-locale.sh << "EOF"
## Use the current locale charset for filenames
## in applications using GLib
#export G_FILENAME_ENCODING=@locale
#EOF

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

