#!/bin/sh

. ./_blfsset.sh

APPNAME=cyrus-sasl
VER=2.1.26
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	openldap dmalloc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_openldap} -eq "1" ]; then
  export WITHLDAP="--with-ldap "
  export ENABLELDAP="--enable-ldapdb "
else
  export WITHLDAP=""
  export ENABLELDAP=""
fi

if [ ${OPTION_dmalloc} -eq "1" ]; then
  export WITHDMALLOC="--with-dmalloc=/usr/lib "
else
  export WITHDMALLOC=""
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/cyrus-sasl-$VER-fixes-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo Autoreconfing...
autoreconf -fi \
        1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1
pushd saslauthd
autoreconf -fi \
        1>> $LOG/$TARGET.0_auto.log 2>&1 || exit 1
popd

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
            --with-dbpath=/var/lib/sasl/sasldb2 \
            --with-saslauthd=/var/run/saslauthd \
            --enable-auth-sasldb \
	    $WITHLDAP $ENABLELDAP $WITHDMALLOC \
            CFLAGS=-fPIC \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

if [ ${OPTION_openldap} -eq "1" ]; then
  echo Making dependencies when enabling openldap...
  make -C include \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1
  make -C sasldb \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1
  make -C plugins \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1
fi

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_installl.log 2>&1 || exit 1

if [ ${OPTION_openldap} -eq "1" ]; then
  paco -p+ $TARGET "libtool --mode=install install plugins/libldapdb.la /usr/lib/sasl2" \
	1>> $LOG/$TARGET.3_installl.log 2>&1 || exit 1
fi

install -v -m755 -d /usr/share/doc/cyrus-sasl-$VER \
	1>> $LOG/$TARGET.3_installl.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 doc/{*.{html,txt,fig},ONEWS,TODO} \
    saslauthd/LDAP_SASLAUTHD /usr/share/doc/cyrus-sasl-$VER" \
	1>> $LOG/$TARGET.3_installl.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m700 -d /var/lib/sasl" \
	1>> $LOG/$TARGET.3_installl.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

