#!/bin/sh

. ./_blfsset.sh

APPNAME=curl
VER=7.36.0
TARGET=curl-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	openssl gnutls openldap krb5 libidn libssh2 \
        c-ares cacerts libgssapi libmetalink
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_libssh2} -eq "1" ]; then
  export WITHSSH2="--with-libssh2 "
else
  export WITHSSH2=""
fi

if [ ${OPTION_gnutls} -eq "1" ]; then
  export WITHGNUTLS="--without-ssl --with-gnutls "
  export WITHCAPATH=" "
else
  export WITHGNUTLS=""
  export WITHCAPATH="--with-ca-path=/etc/ssl/certs "
fi

if [ ${OPTION_libgssapi} -eq "1" ]; then
  export WITHGSSAPI="--with-gssapi "
else
  export WITHGSSAPI=""
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching unofficial...
#patch -Np1 -i $WRK/patch/curl-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
	--disable-static \
	--enable-threaded-resolver \
	$WITHSSH2 $WITHGNUTLS \
	$WITHCAPATH $WITHGSSAPI \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

find docs \( -name "Makefile*" -o -name "*.1" -o -name "*.3" \) -exec rm {} \;
install -v -d -m755 /usr/share/doc/curl-$VER
 
paco -p+ $TARGET "cp -v -R docs/* /usr/share/doc/curl-$VER" \
	1> $LOG/$TARGET.4_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

