#!/bin/sh

. ./_blfsset.sh

APPNAME=bluez
VER=4.101
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	dbus glib-2
. $WRK/_checkOptions.sh  \
	alsa-lib check gst-plugins-base-0 \
        libsndfile libusb-compat
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
CONF_OPTIONS="\
--prefix=/usr \
            --sysconfdir=/etc \
            --localstatedir=/var \
            --libexecdir=/lib \
            --enable-bccmd \
            --enable-dfutool \
            --enable-dund \
            --enable-hid2hci \
            --enable-hidd \
            --enable-pand \
            --enable-tools \
            --enable-wiimote \
            --disable-test \
            --without-systemdunitdir \
"
CONF_OPTIONS+="\
$([ "${OPTION_alsalib}" -eq 1 ] && echo --enable-alsa) \
$([ "${OPTION_gstpluginsbase0}" -eq 1 ] && echo --enable-gstreamer) \
$([ "${OPTION_libusbcompat}" -eq 1 ] && echo --enable-usb ) \
"

echo $CONF_OPTIONS \
	> $LOG/$TARGET.1_conf.log

./configure $CONF_OPTIONS \
	1>> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for CONFFILE in audio input network serial ; do
    paco -p+ $TARGET "\
    install -v -m644 ${CONFFILE}/${CONFFILE}.conf /etc/bluetooth/${CONFFILE}.conf" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
done

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

