#!/bin/sh

. ./_blfsset.sh

APPNAME=baekmuk-ttf
VER=2.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh fontconfig
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

paco -p  $TARGET "\
install -v -d -m755 /usr/share/fonts/baekmuk"

echo Installing...
paco -p+ $TARGET "\
install -v -m644 ttf/*.ttf /usr/share/fonts/baekmuk" \
	1> $LOG/$TARGET.1_install.log 2>&1 || exit 1
 
fc-cache -v /usr/share/fonts/baekmuk

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

