#!/bin/sh

. ./_blfsset.sh

APPNAME=apr-util
VER=1.5.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	apr
. $WRK/_checkOptions.sh  \
	openssl openldap db freetds \
        expat unixODBC mysql postgresql sqlite
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_openldap} -eq "1" ]; then
  export WITHLDAP="--with-ldap "
else
  export WITHLDAP=""
fi

if [ ${OPTION_db} -eq "1" ]; then
  export WITHDB="--with-berkeley-db=/usr "
else
  export WITHDB=""
fi

if [ ${OPTION_openssl} -eq "1" ]; then
  export WITHOPENSSL="--with-openssl=/usr --with-crypto "
else
  export WITHOPENSSL=""
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
#./configure --prefix=/usr \
#	--with-apr=/usr/bin/apr-1-config \
./configure --prefix=/usr    \
	    --with-apr=/usr  \
            --with-gdbm=/usr \
	$WITHLDAP \
	$WITHDB \
	$WITHOPENSSL \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

