#!/bin/sh

. ./_blfsset.sh

APPNAME=httpd
VER=2.4.6
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET
. $WRK/_checkRequired.sh \
	apr-util
. $WRK/_checkOptions.sh  \
	openssl \
	db doxygen lynx openldap pcre rsync \
        distcache lua
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_pcre} -eq "1" ]; then
  export WITHPCRE="--with-pcre "
else
  export WITHPCRE=""
fi

if [ ${OPTION_openldap} -eq "1" ]; then
  export WITHLDAP="--with-ldap --enable-authnz-ldap --enable-ldap "
else
  export WITHLDAP=""
fi

#if [ ${OPTION_apr} -eq "1" ]; then
#  export WITHAPR="--with-apr=/usr "
#else
#  export WITHAPR=""
#fi

#if [ ${OPTION_aprutil} -eq "1" ]; then
#  export WITHAPRUTIL="--with-apr-util=/usr "
#else
#  export WITHAPRUTIL=""
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

groupadd -g 25 apache &&
useradd -c "Apache Server" -d /srv/www -g apache \
        -s /bin/false -u 25 apache

Patching
patch -Np1 -i $DLD/httpd-$VER-blfs_layout-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --enable-layout=BLFS                            \
            --enable-mods-shared="all cgi"                  \
            --enable-mpms-shared=all                        \
            --with-apr=/usr/bin/apr-1-config                \
            --with-apr-util=/usr/bin/apu-1-config           \
            --enable-suexec=shared                          \
            --with-suexec-bin=/usr/lib/httpd/suexec         \
            --with-suexec-docroot=/srv/www                  \
            --with-suexec-caller=apache                     \
            --with-suexec-userdir=public_html               \
            --with-suexec-logfile=/var/log/httpd/suexec.log \
            --with-suexec-uidmin=100 \
	$WITHLDAP \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
mv -v /usr/sbin/suexec /usr/lib/httpd/suexec" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chgrp apache /usr/lib/httpd/suexec
chmod 4754 /usr/lib/httpd/suexec

chown -v -R apache:apache /srv/www \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

HOSTNAME=`hostname`
sed -i 's/#ServerName.*$/&\nServerName '$HOSTNAME':80/' /etc/httpd/httpd.conf

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

