#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=197
TARGET=systemd-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --localstatedir=/var \
            --libexecdir=/usr/lib \
            --docdir=/usr/share/doc/systemd-197 \
            --with-rootprefix= \
            --with-rootlibdir=/lib \
            --with-kbd-loadkeys=/bin/loadkeys \
            --with-kbd-setfont=/bin/setfont \
            --enable-split-usr \
            --disable-gudev \
            --without-python \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
systemd-machine-id-setup" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

for tool in runlevel reboot shutdown poweroff halt telinit; do
   paco -p+ $TARGET "\
     ln -sfv ../bin/systemctl /sbin/$tool"
done

paco -p+ $TARGET "\
ln -sfv ../lib/systemd/systemd /sbin/init"

paco -p+ $TARGET "\
mkdir -pv /var/log/journal"

paco -p+ $TARGET "\
sed -i "s@0775 root lock@0755 root root@g" /usr/lib/tmpfiles.d/legacy.conf"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.

