#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=1.42.7
TARGET=e2fsprogs-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

mkdir -v build
cd build

echo \ \ Configuring...
../configure --prefix=/usr         \
             --with-root-prefix="" \
             --enable-elf-shlibs   \
             --disable-libblkid    \
             --disable-libuuid     \
             --disable-uuidd       \
             --disable-fsck        \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

echo \ \ Installing...
paco -p+ $TARGET "make install-libs" \
	1> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

chmod -v u+w /usr/lib/{libcom_err,libe2p,libext2fs,libss}.a

paco -p+ $TARGET "gunzip -v /usr/share/info/libext2fs.info.gz" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "install-info --dir-file=/usr/share/info/dir \
             /usr/share/info/libext2fs.info" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

makeinfo -o      doc/com_err.info ../lib/et/com_err.texinfo
paco -p+ $TARGET "install -v -m644 doc/com_err.info /usr/share/info" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

paco -p+ $TARGET "install-info --dir-file=/usr/share/info/dir \
             /usr/share/info/com_err.info" \
	1>> $LOG/$CHAP.$TARGET.4_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo \ \ Removing directory...
cd ../.. && rm -fr $TARGETDIR

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Done.

