#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

VER=2.23.1
TARGET=binutils-$VER
TARGETBALL=${TARGET}.tar.bz2
TARGETDIR=$TARGET

echo $CHAP: $TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR
rm -fr binutils-build

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

mkdir -v ../binutils-build
cd ../binutils-build

echo \ \ Configuring...
CC=$LFS_TGT-gcc            \
AR=$LFS_TGT-ar             \
RANLIB=$LFS_TGT-ranlib     \
../binutils-$VER/configure \
    --prefix=/tools        \
    --disable-nls          \
    --with-lib-path=/tools/lib \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

echo \ \ Cleaning..
make -C ld clean \
	1> $LOG/$CHAP.$TARGET.4_clean.log 2>&1

echo \ \ Making ld...
make -C ld LIB_PATH=/usr/lib:/lib \
	1> $LOG/$CHAP.$TARGET.5_make.log 2>&1

echo \ \ Copying...
cp -v ld/ld-new /tools/bin \
	1> $LOG/$CHAP.$TARGET.6_copy.log 2>&1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/lfstime.txt

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR && rm -fr binutils-build

echo \ \ Done.

