#/bin/sh

CHAP=6
APPNAME=systemd
VER=239
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

ln -sf /tools/bin/true /usr/bin/xsltproc

echo \ \ Extract manpage tarball...
tar -xf $DLD/systemd-man-pages-$VER.tar.xz || \
  (echo Not found manpage tarball && exit 1)

sed '166,$ d' -i src/resolve/meson.build

echo \ \ Patching...
patch -Np1 -i $DLD/systemd-239-glibc_statx_fix-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's/GROUP="render", //' rules/50-udev-default.rules.in

mkdir -p build
cd       build

echo \ \ Configuring...
LANG=en_US.UTF-8                   \
meson --prefix=/usr                \
      --sysconfdir=/etc            \
      --localstatedir=/var         \
      -Dblkid=true                 \
      -Dbuildtype=release          \
      -Ddefault-dnssec=no          \
      -Dfirstboot=false            \
      -Dinstall-tests=false        \
      -Dkill-path=/bin/kill        \
      -Dkmod-path=/bin/kmod        \
      -Dldconfig=false             \
      -Dmount-path=/bin/mount      \
      -Drootprefix=                \
      -Drootlibdir=/lib            \
      -Dsplit-usr=true             \
      -Dsulogin-path=/sbin/sulogin \
      -Dsysusers=false             \
      -Dumount-path=/bin/umount    \
      -Db_lto=false                \
      ..                           \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
LANG=en_US.UTF-8 ninja \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "\
LANG=en_US.UTF-8 ninja install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
rm -rfv /usr/lib/rpm" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

#for tool in runlevel reboot shutdown poweroff halt telinit; do
#     porg -lp+ $TARGET "\
#     ln -sfv ../bin/systemctl /sbin/${tool}" \
#	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
#done
#porg -lp+ $TARGET "\
#ln -sfv ../lib/systemd/systemd /sbin/init" \
#	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

rm -f /usr/bin/xsltproc

porg -lp+ $TARGET "\
systemd-machine-id-setup" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

cat > /lib/systemd/systemd-user-sessions << "EOF"
#!/bin/bash
rm -f /run/nologin
EOF
chmod 755 /lib/systemd/systemd-user-sessions
porg -lp+ $TARGET "\
touch /lib/systemd/systemd-user-sessions" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
