#/bin/sh

CHAP=6

. ./_lfsset.sh

APPNAME=linux
TARGET=$APPNAME-$LINUX_VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

echo \ \ Making mrproper...
make mrproper \
	1> $LOG/$CHAP.$TARGET.1_mrproper.log 2>&1 || exit 1

echo \ \ Installing...
make INSTALL_HDR_PATH=dest headers_install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

find dest/include \( -name .install -o -name ..install.cmd \) -delete \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

cp -rv dest/include/* /usr/include \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
