#/bin/sh

CHAP=6
APPNAME=libcap
VER=2.25
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i '/install.*STALIBNAME/d' libcap/Makefile

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "\
make RAISE_SETFCAP=no lib=lib prefix=/usr install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
chmod 755 /usr/lib/libcap.so

porg -lp+ $TARGET "\
mv -v /usr/lib/libcap.so.* /lib" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfv ../../lib/$(readlink /usr/lib/libcap.so) /usr/lib/libcap.so" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
