#/bin/sh

CHAP=6
APPNAME=glibc
VER=2.26
TZDATATARBALL=tzdata2017b.tar.gz
KERNELVER=2.6.32
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Patching...
patch -Np1 -i $DLD/glibc-$VER-fhs-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

case $(uname -m) in
    x86) ln -s ld-linux.so.2 /lib/ld-lsb.so.3
    ;;
    x86_64) ln -s ../lib/ld-linux-x86-64.so.2 /lib64
            ln -s ../lib/ld-linux-x86-64.so.2 /lib64/ld-lsb-x86-64.so.3
    ;;
esac

mkdir build
cd    build

echo \ \ Configuring...
../configure --prefix=/usr          \
             --enable-kernel=2.6.32 \
             --enable-obsolete-rpc  \
             --enable-stack-protector=strong \
             libc_cv_slibdir=/lib   \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
touch /etc/ld.so.conf
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

find /lib | porg -lp $TARGET

porg -lp+ $TARGET "\
cp -v ../nscd/nscd.conf /etc/nscd.conf" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
mkdir -p /var/cache/nscd

echo \ \ Creating locales...
porg -lp+ $TARGET "mkdir -p /usr/lib/locale"
porg -lp+ $TARGET "localedef -i cs_CZ -f UTF-8 cs_CZ.UTF-8"
porg -lp+ $TARGET "localedef -i de_DE -f ISO-8859-1 de_DE"
porg -lp+ $TARGET "localedef -i de_DE@euro -f ISO-8859-15 de_DE@euro"
porg -lp+ $TARGET "localedef -i de_DE -f UTF-8 de_DE.UTF-8"
porg -lp+ $TARGET "localedef -i en_GB -f UTF-8 en_GB.UTF-8"
porg -lp+ $TARGET "localedef -i en_HK -f ISO-8859-1 en_HK"
porg -lp+ $TARGET "localedef -i en_PH -f ISO-8859-1 en_PH"
porg -lp+ $TARGET "localedef -i en_US -f ISO-8859-1 en_US"
porg -lp+ $TARGET "localedef -i en_US -f UTF-8 en_US.UTF-8"
porg -lp+ $TARGET "localedef -i es_MX -f ISO-8859-1 es_MX"
porg -lp+ $TARGET "localedef -i fa_IR -f UTF-8 fa_IR"
porg -lp+ $TARGET "localedef -i fr_FR -f ISO-8859-1 fr_FR"
porg -lp+ $TARGET "localedef -i fr_FR@euro -f ISO-8859-15 fr_FR@euro"
porg -lp+ $TARGET "localedef -i fr_FR -f UTF-8 fr_FR.UTF-8"
porg -lp+ $TARGET "localedef -i it_IT -f ISO-8859-1 it_IT"
porg -lp+ $TARGET "localedef -i it_IT -f UTF-8 it_IT.UTF-8"
porg -lp+ $TARGET "localedef -i ja_JP -f EUC-JP ja_JP"
porg -lp+ $TARGET "localedef -i ja_JP -f UTF-8 ja_JP.UTF-8"
porg -lp+ $TARGET "localedef -i ru_RU -f KOI8-R ru_RU.KOI8-R"
porg -lp+ $TARGET "localedef -i ru_RU -f UTF-8 ru_RU.UTF-8"
porg -lp+ $TARGET "localedef -i tr_TR -f UTF-8 tr_TR.UTF-8"
porg -lp+ $TARGET "localedef -i zh_CN -f GB18030 zh_CN.GB18030"

cat > /etc/nsswitch.conf << "EOF"
# Begin /etc/nsswitch.conf

passwd: files
group: files
shadow: files

hosts: files dns
networks: files

protocols: files
services: files
ethers: files
rpc: files

# End /etc/nsswitch.conf
EOF
porg -lp+ $TARGET "touch /etc/nsswitch.conf"

tar -xf $DLD/$TZDATATARBALL || (echo Not found tzdata tarball && exit 1)

ZONEINFO=/usr/share/zoneinfo
mkdir -p $ZONEINFO/{posix,right}

for tz in etcetera southamerica northamerica europe africa antarctica  \
          asia australasia backward pacificnew systemv; do
    zic -L /dev/null   -d $ZONEINFO       -y "sh yearistype.sh" ${tz}
    zic -L /dev/null   -d $ZONEINFO/posix -y "sh yearistype.sh" ${tz}
    zic -L leapseconds -d $ZONEINFO/right -y "sh yearistype.sh" ${tz}
done

porg -lp+ $TARGET "\
cp -pv zone.tab zone1970.tab iso3166.tab $ZONEINFO" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
zic -d $ZONEINFO -p America/New_York" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

unset ZONEINFO

TimeEnd chap6

#porg -lp+ $TARGET "tzselect"

porg -lp+ $TARGET "\
cp -v /usr/share/zoneinfo/Japan \
    /etc/localtime" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

cat > /etc/ld.so.conf << "EOF"
# Begin /etc/ld.so.conf
/usr/local/lib
/opt/lib

EOF
porg -lp+ $TARGET "touch /etc/ld.so.conf"

porg -lp+ $TARGET "mkdir -p /etc/ld.so.conf.d"

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
