#/bin/sh

CHAP=5
APPNAME=perl
VER=5.28.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
sh Configure -des -Dprefix=/tools -Dlibs=-lm -Uloclibpth -Ulocincpth \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
cp -v perl cpan/podlators/scripts/pod2man /tools/bin \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1
mkdir -pv /tools/lib/perl5/$VER \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1
cp -Rv lib/* /tools/lib/perl5/$VER \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1

TimeEnd chap5

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
