#/bin/sh

CHAP=5
APPNAME=glibc
VER=2.28
KERNELVER=3.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Patching unofficial
patch -Np1 -i $WRK/glibc-$VER-without-man.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

mkdir build
cd    build

echo \ \ Configuring...
../configure                             \
      --prefix=/tools                    \
      --host=$LFS_TGT                    \
      --build=$(../scripts/config.guess) \
      --enable-kernel=$KERNELVER         \
      --with-headers=/tools/include      \
      libc_cv_forced_unwind=yes          \
      libc_cv_c_cleanup=yes              \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

echo 'int main(){}' > dummy.c
$LFS_TGT-gcc dummy.c
readelf -l a.out | grep ': /tools'
rm dummy.c a.out

TimeEnd chap5

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
