#/bin/sh

. ./_clfsset.sh

APPNAME=kbd
VER=2.0.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD64}" PKG_CONFIG_PATH="/tools/lib64/pkgconfig" \
    ./configure --prefix=/usr --disable-vlock --enable-optional-progs \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/bin/{loadkeys,setfont} /bin \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mkdir -v /usr/share/doc/kbd-2.0.1 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
cp -R -v docs/doc/* /usr/share/doc/kbd-2.0.1 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
