#/bin/sh

. ./_clfsset.sh

APPNAME=isl
VER=0.12.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.lzma
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

echo Configuring...
CC="gcc -isystem /usr/include ${BUILD64}" \
LDFLAGS="-Wl,-rpath-link,/usr/lib64:/lib64 ${BUILD64}" \
  ./configure --prefix=/usr --libdir=/usr/lib64 \
        1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mkdir -pv /usr/share/gdb/auto-load/usr/lib64 \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/lib64/*gdb.py /usr/share/gdb/auto-load/usr/lib64 \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

