#/bin/sh

CLFS=/mnt/clfs

TARGET=bash_startup_files

cat > /etc/profile << "EOF"
# Begin /etc/profile

for script in /etc/profile.d/*.sh
do
  source $script
done
unset script

# End /etc/profile
EOF
paco -p $TARGET "touch /etc/profile"

install -d -m755 /etc/profile.d

cat > /etc/profile.d/05-i18n.sh << "EOF"
# Begin /etc/profile.d/05-i18n.sh

export LANG=ja_JP.UTF-8
export G_FILENAME_ENCODING=@locale
 
# End /etc/profile.d/05-i18n.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/05-i18n.sh"

cat > /etc/profile.d/10-path.sh << "EOF"
# Begin /etc/profile.d/10-path.sh

if [ "$EUID" -eq 0 ]; then
  export PATH="/sbin:/bin:/usr/sbin:/usr/bin"
  if [ -d "/usr/local/sbin" ]; then
    export PATH="$PATH:/usr/local/sbin"
  fi
else
  export PATH="/bin:/usr/bin"
fi

if [ -d "/usr/local/bin" ]; then
  export PATH="$PATH:/usr/local/bin"
fi

if [ -d "$HOME/bin" ]; then
  export PATH="$HOME/bin:$PATH"
fi

# End /etc/profile.d/10-path.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/05-i18n.sh"

cat > /etc/profile.d/10-pkg_config_path.sh << "EOF"
# Begin /etc/profile.d/10-pkg_config_path.sh

export PKG_CONFIG_PATH32="/usr/lib/pkgconfig"
export PKG_CONFIG_PATHN32="/usr/lib32/pkgconfig"
export PKG_CONFIG_PATH64="/usr/lib64/pkgconfig"

# End /etc/profile.d/10-pkg_config_path.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/10-pkg_config_path.sh"

cat > /etc/profile.d/10-xdg.sh << "EOF"
# Begin /etc/profild.d/10-xdg.sh

export XDG_DATA_DIRS="/usr/share"
export XDG_CONFIG_DIRS="/etc/xdg:/usr/share"

# End /etc/profild.d/10-xdg.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/10-xdg.sh"

cat > /etc/profile.d/15-xorg.sh << "EOF"
# Begin /etc/profile.d/15-xorg.sh

export XORG_PREFIX=/usr/X11R7

export PATH="${PATH}:${XORG_PREFIX}/bin"
export PKG_CONFIG_PATH32="${PKG_CONFIG_PATH32}${PKG_CONFIG_PATH32+:}${XORG_PREFIX}/lib/pkgconfig"
export PKG_CONFIG_PATHN32="${PKG_CONFIG_PATHN32}${PKG_CONFIG_PATHN32+:}${XORG_PREFIX}/lib32/pkgconfig"
export PKG_CONFIG_PATH64="${PKG_CONFIG_PATH64}${PKG_CONFIG_PATH64+:}${XORG_PREFIX}/lib64/pkgconfig"
export ACLOCAL="aclocal -I $XORG_PREFIX/share/aclocal"

# End /etc/profile.d/15-xorg.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/15-xorg.sh"

cat > /etc/profile.d/50-dircolors.sh << "EOF"
# Begin /etc/profile.d/50-dircolors.sh

alias ls='ls --color=auto'
if [ -f "$HOME/.dircolors" ]; then
  eval `dircolors -b "$HOME/.dircolors"`
else
  if [ -f "/etc/dircolors" ]; then
    eval `dircolors -b "/etc/dircolors"`
  fi
fi

# End /etc/profile.d/50-dircolors.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/50-dircolors.sh"

dircolors -p > /etc/dircolors

cat > /etc/profile.d/50-history.sh << "EOF"
# Begin /etc/profile.d/50-history.sh

export HISTSIZE=1000
export HISTIGNORE="&:[bf]g:exit"

# End /etc/profile.d/50-history.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/50-history.sh"

cat > /etc/profile.d/50-prompt.sh << "EOF"
# Begin /etc/profile.d/50-prompt.sh

export PS1="\u:\w\$ "
if [ "${TERM:0:5}" = "xterm" ]; then
  export PS1="\[\e]2;\u@\H :: \w\a\]$PS1"
fi

shopt -s checkwinsize

# End /etc/profile.d/50-prompt.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/50-prompt.sh"

cat > /etc/profile.d/50-readline.sh << "EOF"
# Begin /etc/profile.d/50-readline.sh

if [ -z "$INPUTRC" ]; then
  if [ -f "$HOME/.inputrc" ]; then
    export INPUTRC="$HOME/.inputrc"
  else
    if [ -f "/etc/inputrc" ]; then
      export INPUTRC="/etc/inputrc"
    fi
  fi
fi

# End /etc/profile.d/50-readline.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/50-readline.sh"

cat > /etc/profile.d/50-umask.sh << "EOF"
# Begin /etc/profile.d/50-umask.sh

if [ "`id -un`" = "`id -gn`" -a $EUID -gt 99 ]; then
  umask 002
else
  umask 022
fi

# End /etc/profile.d/50-umask.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/50-umask.sh"

cat > /etc/profile.d/50-multilib.sh << "EOF"
# Begin /etc/profile.d/50-multilib.sh

export BUILD32="-m32"
export BUILD64="-m64"

export CLFS_TARGET32="i686-pc-linux-gnu"

export LD_BUILD32="-m elf_i386"
export LD_BUILD64="-m elf_x86_64"

# End /etc/profile.d/50-multilib.sh
EOF

paco -p+ $TARGET "touch /etc/profile.d/50-multilib.sh"
