#!/bin/sh

APPNAME=qt3
VER=3.3.8.d
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=qt3

. ./_blfsset.sh
. ./Xorg/_xorgset.sh

LD_FLAGS='-L/usr/X11/lib'
LD_LIBRARY_PATH=/usr/X11/lib

echo Check Required...
./_checkRequired.sh libjpeg libmng || exit 1

if test "$1" == "check"; then
  exit 0
fi

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

sed -i '/QMAKE_RPATH/d' mkspecs/linux*/qmake.conf

export PATH=$PWD/bin:$PATH 
export LD_LIBRARY_PATH=$PWD/lib:$LD_LIBRARY_PATH

echo \ \ Patching...
patch -Np1 -i $DLD/qt-$VER-libpng15-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo \ \ Configuring...
echo yes | ./configure -prefix /usr \
            -docdir /usr/share/doc/qt \
            -headerdir /usr/include/qt \
            -plugindir /usr/lib/qt/plugins \
            -datadir /usr/share/qt \
            -translationdir /usr/share/qt/translations \
            -sysconfdir /etc/qt \
            -qt-gif \
            -system-zlib \
            -system-libpng \
            -system-libjpeg \
            -system-libmng \
            -plugin-imgfmt-png \
            -plugin-imgfmt-jpeg \
            -plugin-imgfmt-mng \
            -no-exceptions \
            -thread \
            -tablet \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

ln -v -sf libqt-mt.so /usr/lib/libqt.so &&
ln -v -snf ../../bin /usr/share/qt/bin &&
ln -v -snf ../../include/qt /usr/share/qt/include &&
ln -v -snf ../../lib /usr/share/qt/lib &&
cp -v -r doc/man /usr/share &&
cp -v -r examples /usr/share/doc/qt

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

