#!/bin/sh

. ./_blfsset.sh

APPNAME=nss
VER=3.38
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/nss-$VER.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh nspr
. $WRK/_checkOptions.sh  sqlite p11-kit
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/nss-$VER-standalone-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Making
cd nss
make -j1 BUILD_OPT=1                      \
  NSPR_INCLUDE_DIR=/usr/include/nspr  \
  USE_SYSTEM_ZLIB=1                   \
  ZLIB_LIBS=-lz                       \
  NSS_ENABLE_WERROR=0                 \
  $([ $(uname -m) = x86_64 ] && echo USE_64=1) \
  $([ -f /usr/include/sqlite3.h ] && echo NSS_USE_SYSTEM_SQLITE=1) -j1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
cd ../dist

porg -lp+ $TARGET "\
install -v -m755 Linux*/lib/*.so /usr/lib" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644 Linux*/lib/{*.chk,libcrmf.a} /usr/lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/include/nss

porg -lp+ $TARGET "\
cp -v -RL {public,private}/nss/* /usr/include/nss" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

chmod 644 /usr/include/nss/* 

porg -lp+ $TARGET "\
install -v -m755 Linux*/bin/{certutil,nss-config,pk12util} /usr/bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\ 
install -v -m644 Linux*/lib/pkgconfig/nss.pc /usr/lib/pkgconfig" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

