#!/bin/sh

. ./_blfsset.sh

APPNAME=llvm
VER=6.0.1
VER_CFE=6.0.1
VER_CRT=6.0.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.src.tar.xz
TARGETDIR=$TARGET.src

unset MAKEFLAGS
MAKEOPTS="-j1"

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake
. $WRK/_checkOptions.sh  \
        python-2 \
	doxygen graphviz libxml2 texlive zip \
        ocaml sphinx valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

tar -xf $DLD/cfe-${VER_CFE}.src.tar.xz -C tools || exit 1
tar -xf $DLD/compiler-rt-${VER_CRT}.src.tar.xz -C projects || exit 1
mv tools/cfe-${VER_CFE}.src tools/clang
mv projects/compiler-rt-${VER_CRT}.src projects/compiler-rt

mkdir build
cd    build

Configuring
CC=gcc CXX=g++                              \
cmake -DCMAKE_INSTALL_PREFIX=/usr           \
      -DLLVM_ENABLE_FFI=ON                  \
      -DCMAKE_BUILD_TYPE=Release            \
      -DLLVM_BUILD_LLVM_DYLIB=ON            \
      -DLLVM_LINK_LLVM_DYLIB=ON             \
      -DLLVM_TARGETS_TO_BUILD="host;AMDGPU" \
      -DLLVM_BUILD_TESTS=ON                 \
      -Wno-dev -G Ninja ..                  \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
ninja \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "\
ninja install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

