#!/bin/sh

. ./_blfsset.sh

APPNAME=libtiff
VER=4.0.8
TARGET=libtiff-$VER
TARGETBALL=$DLD/tiff-$VER.tar.gz
TARGETDIR=tiff-$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	libjpeg-turbo jbigkit freeglut
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	--disable-static \
	$([ ${OPTION_jbigkit} -eq "1" ] && echo --enable-jbig) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

