#!/bin/sh

. ./_blfsset.sh

APPNAME=libprelude
VER=3.0.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gnutls libgcrypt
. $WRK/_checkOptions.sh  \
	swig lua valgrind ruby
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#sed -i -e '/gets is a/d' libmissing/stdio.in.h

#echo Patching unofficial...
#patch -Np1 -i $WRK/patch/libprelude-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
#patch -Np1 -i $WRK/patch/libprelude-${VER}_lua_strlen.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#echo Patching unofficial...
#patch -Np1 -i $WRK/patch/libprelude-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
	--with-ltdl-include=/usr/include \
	--with-ltdl-lib=/usr/lib \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

