#!/bin/sh

. ./_blfsset.sh

APPNAME=libcap
VER=2.25
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-$VER.tar.xz
TARGETDIR=$APPNAME-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	libcap Linux-PAM
. $WRK/_checkOptions.sh
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Making
make -C pam_cap \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp+ $TARGET "\
install -v -m755 pam_cap/pam_cap.so /lib/security" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -v -m644 pam_cap/capability.conf /etc/security" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
